' mdb2Csv.vbs
'
' Converts <input file> from an Access table to a comma-separated
' text file and saves the results to <output file>.  Requires 
' Microsoft Access.
' 
' Usage:
'  WScript mdb2csv.vbs <input file> <output file>

' Constants, taken from the Access type library
Const acExportDelim = 2

' OpenTextFile iomode constants
Const ForReading = 1
Const ForAppending = 8

Dim oFileSys
Dim oAccess
Dim sTmpName
Dim oDesFile, oTmpFile

Set oFileSys = CreateObject("Scripting.FileSystemObject")
oFileSys.DeleteFile WScript.Arguments(1)

Set oAccess = CreateObject("Access.Application")

On Error Resume Next

'Open the database
oAccess.OpenCurrentDatabase WScript.Arguments(0)
'Do not show access
oAccess.visible = false

If Err = 0 Then
	With oAccess.CurrentData
		'Open the final output FileSystemObject
		Set oDesFile = oFileSys.OpenTextFile( WScript.Arguments(1), ForAppending, True)
		'Iterate through each table
	   For Each obj In .AllTables
	   	'Skip system tables starting with MSys
	   	If Left(obj.name, 4) <> "MSys" Then
	   		'Get a temp file for this tables data
				sTmpName = oFileSys.GetSpecialFolder(2) & "\" & oFileSys.GetTempName
				'Write a header to seperate each tables data in the final file
				oDesFile.WriteLine("***********************************************************************************")
				oDesFile.WriteLine("********** START OF TABLE '" & obj.name & "'")
				oDesFile.WriteLine("********** Output File: " & WScript.Arguments(1))
				oDesFile.WriteLine("***********************************************************************************")
		
				'Export the table data to the temp file
				oAccess.DoCmd.TransferText acExportDelim, "", obj.Name, sTmpName
				'Open the temp file
				Set oTmpFile = oFileSys.OpenTextFile( sTmpName, ForReading )
				'Write the whole temp file to the final file
				oDesFile.Write( oTmpFile.ReadAll )
				
				'Write the end of table separator
				oDesFile.WriteLine("")
				oDesFile.WriteLine("")
				
				'Close and delete the temp file
				oTmpFile.Close
				oFileSys.DeleteFile sTmpName
			End if
    	Next
	End With
End If

'Quit access
oAccess.Quit

If (Err <> 0) and (Err.Description <> NULL) Then
	MsgBox Err.Description, vbExclamation, "Error"
	Err.Clear
End If