#!/bin/sh

BC_LIB=
export BC_LIB

BC_PACKAGE_TYPE=
export BC_PACKAGE_TYPE

export QT_QPA_PLATFORM=xcb

EXEC="$BC_LIB/BCompare"

if [ -n "$LD_LIBRARY_PATH" ]; then
export LD_LIBRARY_PATH="$BC_LIB:$LD_LIBRARY_PATH"
else
export LD_LIBRARY_PATH="$BC_LIB"
fi

#check to see if we have all of the shared libraries.
if ldd "$EXEC" | grep -q "not found" ; then
   echo Some Shared Libraries were not found
   ldd "$EXEC"
   exit 1
fi

########################################
# initialize context menu action scripts for KDE 3.5
if [ "$KDE_FULL_SESSION" = "true" ] && [ -f "$BC_LIB/kde_context_menu" ] ; then
	if [ "$KDE_SESSION_VERSION" != "4" ] && [ "$KDE_SESSION_VERSION" != "5" ]; then
		mkdir -p "$HOME/.beyondcompare"
		if [ -d "$HOME/.kde/share/apps/konqueror" ]; then
			mkdir -p "$HOME/.kde/share/apps/konqueror/servicemenus"
		fi
		"$BC_LIB/kde_context_menu"
	fi
fi

########################################
# execute the program
ARGS="";
while [ "$#" -gt 0 ]; do
	ARGS=$ARGS" \"$1\""
	shift 1
done
/bin/bash -c "exec -a $0 $EXEC $ARGS > /dev/null 2>&1" $0

########################################
# set exit code / wait on existing instance
EXIT=$?
if [ $EXIT = 99 ]; then
	# detected existing instance of Beyond Compare
	USER_TMP=${TMPDIR:-/tmp}
	EXIT=`cat ${USER_TMP}/BC5_.$$`
	rm -f ${USER_TMP}/BC5_.$$
fi
exit $EXIT
