hmLoadTopic({
hmKeywords:"attributes,attributes compare,compare,compare attributes,compare file contents,compare file size,compare timestamps,compare version info,comparison criteria,comparison criteria setting,Folder Sync,Folder Sync rules,timestamps,timestamps compare,version,version compare version info",
hmTitle:"Folder Sync Comparison Settings",
hmDescription:"These settings control what is considered a difference in a folder session.",
hmPrevLink:"sessiondirsyncops.html",
hmNextLink:"sessiondirsynchandling.html",
hmParentLink:"sessiondirsync.html",
hmBreadCrumbs:"<a href=\"settings_reference.html\">Settings Reference<\/a> &gt; <a href=\"session_settings.html\">Session Settings<\/a> &gt; <a href=\"sessiondirsync.html\">Folder Sync<\/a>",
hmTitlePath:"Settings Reference > Session Settings > Folder Sync > Comparison",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">Folder Sync Comparison Settings<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_Normal\">These settings control what is considered a difference in a folder session.<\/p>\n\r<p class=\"p_Subtitle\"><span class=\"f_Subtitle\">Quick tests<\/span><\/p>\n\r<p class=\"p_Normal\">These comparison tests can be performed simply by reading folders and are much quicker than tests that require reading individual files.<\/p>\n\r<p class=\"p_Command\"><span class=\"f_Command\">Compare file size<\/span><\/p>\n\r<p class=\"p_Normal\">Marks files as different if file sizes differ.<\/p>\n\r<p class=\"p_Command\"><span class=\"f_Command\">Compare timestamps<\/span><\/p>\n\r<p class=\"p_Normal\">Compares files\' date and time last modified.  Timestamps must differ by more seconds than the <span class=\"f_Command\">second tolerance<\/span> to be considered mismatches.<\/p>\n\r<p class=\"p_Indented\"><span class=\"f_Command\">Ignore daylight saving difference<\/span> ignores exact hour differences.  This is useful for dealing with the way that different file systems handle Daylight Savings Time.<\/p>\n\r<p class=\"p_Indented\"><span class=\"f_Command\">Ignore timezone differences<\/span> ignores timestamp differences that are multiples of an exact hour.<\/p>\n\r<p class=\"p_Command\"><span class=\"f_Command\">Compare filename case<\/span><\/p>\n\r<p class=\"p_Normal\">Marks files as different if character capitalizations differ.<\/p>\n\r<p class=\"p_Command\"><span class=\"f_Command\">Compare file attributes <\/span><img style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/windows.png\"\/><\/p>\n\r<p class=\"p_Indented\"><span class=\"f_Command\">Archive<\/span> compares files\' archive attribute.  Since merely copying a file can change its archive attribute, you should normally disable this option.<\/p>\n\r<p class=\"p_Indented\"><span class=\"f_Command\">System<\/span> compares files\' system attribute.<\/p>\n\r<p class=\"p_Indented\"><span class=\"f_Command\">Hidden<\/span> compares files\' hidden attribute.<\/p>\n\r<p class=\"p_Indented\"><span class=\"f_Command\">Read-only<\/span> compares files\' read-only attribute.<\/p>\n\r<p class=\"p_Command\"><span class=\"f_Command\">Align filenames with different extensions<\/span><\/p>\n\r<p class=\"p_Normal\">Lines up files whose filenames are the same except for the extensions.<\/p>\n\r<p class=\"p_Command\"><span class=\"f_Command\">Align filenames with different Unicode normalization forms<\/span><\/p>\n\r<p class=\"p_Normal\">Lines up files whose filenames are Unicode equivalent.<\/p>\n\r<p class=\"p_Subtitle\"><span class=\"f_Subtitle\">Tests that require reading files<\/span><\/p>\n\r<p class=\"p_Command\"><span class=\"f_Command\">Compare contents<\/span><\/p>\n\r<p class=\"p_Normal\">Enables size or content-related comparisons.<\/p>\n\r<p class=\"p_Indented\"><span class=\"f_Command\">CRC comparison<\/span> compares files using their CRC values.<\/p>\n\r<p class=\"p_Indented\"><span class=\"f_Command\">Binary comparison<\/span> compares files byte-by-byte.<\/p>\n\r<p class=\"p_Indented\"><span class=\"f_Command\">Rules-based comparison<\/span> compares files based on their <a href=\"file_formats.html\" class=\"topiclink\">file format<\/a> associations.  Allows you to ignore differences in line endings, whitespace, or source code comments.<\/p>\n\r<p class=\"p_Indented\"><span class=\"f_Command\">Skip if quick tests indicate files are the same<\/span> improves comparison speed by only performing the slower, more thorough tests when timestamps are different.<\/p>\n\r<p class=\"p_Command\"><span class=\"f_Command\">Compare versions <\/span><img style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/windows.png\"\/><\/p>\n\r<p class=\"p_Normal\">Compares version information, typically stored in application files (.exe, .dll, .ocx, etc).<\/p>\n\r<p class=\"p_Command\"><span class=\"f_Command\">Override quick test results<\/span><\/p>\n\r<p class=\"p_Normal\">Marks files as matching if a content comparison determines they match even if there are differences in timestamps or other quick tests.<\/p>\n\r"
})
