hmLoadTopic({
hmKeywords:"scripts,scripts reference",
hmTitle:"Scripting Reference",
hmDescription:"A script is a simple text file containing a list of commands which can control the program and automatically perform file operations or produce reports.  See also Scripts and...",
hmPrevLink:"command_line_reference.html",
hmNextLink:"regular_expression_reference.html",
hmParentLink:"index.html",
hmBreadCrumbs:"",
hmTitlePath:"Scripting Reference",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">Scripting Reference<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_Normal\">A script is a simple text file containing a list of commands which can control the program and automatically perform file operations or produce reports.  See also <a href=\"scripts.html\" class=\"topiclink\">Scripts<\/a> and <a href=\"sample_scripts.html\" class=\"topiclink\">Sample Scripts<\/a>.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0.1875rem 0 0.8750rem 0;\"><table style=\"border:none; border-spacing:0; border-collapse:collapse;\">\n\r<tr>\n\r<td style=\"vertical-align:top; background-color:#DADADA; padding:0.1250rem; border:solid 0.1250rem #ffffff;\"><p class=\"p_SingleSpaced\">Notation<\/p>\n\r<\/td>\n\r<td style=\"vertical-align:top; background-color:#DADADA; padding:0.1250rem; border:solid 0.1250rem #ffffff;\"><p class=\"p_SingleSpaced\">Meaning<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr>\n\r<td style=\"vertical-align:top; background-color:#EEEEEE; padding:0.1250rem; border:solid 0.1250rem #ffffff;\"><p class=\"p_SingleSpaced\">|<\/p>\n\r<\/td>\n\r<td style=\"vertical-align:top; background-color:#EEEEEE; padding:0.1250rem; border:solid 0.1250rem #ffffff;\"><p class=\"p_SingleSpaced\">delimits the possible choices<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr>\n\r<td style=\"vertical-align:top; background-color:#EEEEEE; padding:0.1250rem; border:solid 0.1250rem #ffffff;\"><p class=\"p_SingleSpaced\">()<\/p>\n\r<\/td>\n\r<td style=\"vertical-align:top; background-color:#EEEEEE; padding:0.1250rem; border:solid 0.1250rem #ffffff;\"><p class=\"p_SingleSpaced\">surrounds a required expression<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr>\n\r<td style=\"vertical-align:top; background-color:#EEEEEE; padding:0.1250rem; border:solid 0.1250rem #ffffff;\"><p class=\"p_SingleSpaced\">[]<\/p>\n\r<\/td>\n\r<td style=\"vertical-align:top; background-color:#EEEEEE; padding:0.1250rem; border:solid 0.1250rem #ffffff;\"><p class=\"p_SingleSpaced\">surrounds an optional expression<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr>\n\r<td style=\"vertical-align:top; background-color:#EEEEEE; padding:0.1250rem; border:solid 0.1250rem #ffffff;\"><p class=\"p_SingleSpaced\">&lt;&gt;<\/p>\n\r<\/td>\n\r<td style=\"vertical-align:top; background-color:#EEEEEE; padding:0.1250rem; border:solid 0.1250rem #ffffff;\"><p class=\"p_SingleSpaced\">surrounds the description of required user text<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr>\n\r<td style=\"vertical-align:top; background-color:#EEEEEE; padding:0.1250rem; border:solid 0.1250rem #ffffff;\"><p class=\"p_SingleSpaced\">[...]<\/p>\n\r<\/td>\n\r<td style=\"vertical-align:top; background-color:#EEEEEE; padding:0.1250rem; border:solid 0.1250rem #ffffff;\"><p class=\"p_SingleSpaced\">follows an expression that can be repeated<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\">You can use <span class=\"f_Command\">lt<\/span> in place of <span class=\"f_Command\">left<\/span> or <span class=\"f_Command\">rt<\/span> in place of <span class=\"f_Command\">right<\/span> in any of the commands.<\/p>\n\r<p class=\"p_Normal\">These are the script commands (in alphabetical order):<\/p>\n\r<p class=\"p_Normal\"><a href=\"scripting_reference.html#attrib\" class=\"topiclink\">ATTRIB<\/a> <a href=\"scripting_reference.html#beep\" class=\"topiclink\">BEEP<\/a> <a href=\"scripting_reference.html#collapse\" class=\"topiclink\">COLLAPSE<\/a> <a href=\"scripting_reference.html#compare\" class=\"topiclink\">COMPARE<\/a> <a href=\"scripting_reference.html#copy\" class=\"topiclink\">COPY<\/a> <a href=\"scripting_reference.html#copyto\" class=\"topiclink\">COPYTO<\/a> <a href=\"scripting_reference.html#criteria\" class=\"topiclink\">CRITERIA<\/a> <a href=\"scripting_reference.html#delete\" class=\"topiclink\">DELETE<\/a> <a href=\"scripting_reference.html#expand\" class=\"topiclink\">EXPAND<\/a> <a href=\"scripting_reference.html#file-report\" class=\"topiclink\">FILE-REPORT<\/a> <a href=\"scripting_reference.html#filter\" class=\"topiclink\">FILTER<\/a> <a href=\"scripting_reference.html#folder-report\" class=\"topiclink\">FOLDER-REPORT<\/a> <a href=\"scripting_reference.html#hex-report\" class=\"topiclink\">HEX-REPORT<\/a> <a href=\"scripting_reference.html#load\" class=\"topiclink\">LOAD<\/a> <a href=\"scripting_reference.html#log\" class=\"topiclink\">LOG<\/a> <a href=\"scripting_reference.html#media-report\" class=\"topiclink\">MEDIA-REPORT<\/a> <a href=\"scripting_reference.html#move\" class=\"topiclink\">MOVE<\/a> <a href=\"scripting_reference.html#moveto\" class=\"topiclink\">MOVETO<\/a> <a href=\"scripting_reference.html#option\" class=\"topiclink\">OPTION<\/a> <a href=\"scripting_reference.html#pix-report\" class=\"topiclink\">PICTURE-REPORT<\/a> <a href=\"scripting_reference.html#reg-report\" class=\"topiclink\">REGISTRY-REPORT<\/a> <a href=\"scripting_reference.html#rename\" class=\"topiclink\">RENAME<\/a> <a href=\"scripting_reference.html#select\" class=\"topiclink\">SELECT<\/a> <a href=\"scripting_reference.html#snapshot\" class=\"topiclink\">SNAPSHOT<\/a> <a href=\"scripting_reference.html#sync\" class=\"topiclink\">SYNC<\/a> <a href=\"scripting_reference.html#table-report\" class=\"topiclink\">TABLE-REPORT<\/a> <a href=\"scripting_reference.html#text-report\" class=\"topiclink\">TEXT-REPORT<\/a> <a href=\"scripting_reference.html#touch\" class=\"topiclink\">TOUCH<\/a> <a href=\"scripting_reference.html#version-report\" class=\"topiclink\">VERSION-REPORT<\/a><\/p>\n\r<hr style=\"height:2px; color:#000000; border-width:0; background-color:#000000;\" \/><p class=\"p_Normal\"><a id=\"attrib\" class=\"hmanchor\"><\/a><span class=\"f_Subtitle\">ATTRIB<\/span> <img style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/windows.png\"\/><\/p>\n\r<p class=\"p_Normal\">Usage:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">attrib (+|-)&lt;<\/span><span class=\"f_CourierFixed\">attribute set 1<\/span><span class=\"f_CourierFixed\">&gt; [(+|-)&lt;<\/span><span class=\"f_CourierFixed\">attribute set 2<\/span><span class=\"f_CourierFixed\">&gt; [...]]<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">Where &lt;attribute set&gt; is:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">[a][s][h][r]<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\"><img style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/mac.png\"\/> <img style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/linux.png\"\/> The macOS and Linux versions do not support <span class=\"f_Command\">attrib<\/span>.<\/p>\n\r<p class=\"p_Normal\">Sets (<span class=\"f_Command\">+<\/span>) or clears (<span class=\"f_Command\">-<\/span>) the DOS file attributes in the current selection.  Use <span class=\"f_Command\">a<\/span> for archive, <span class=\"f_Command\">s<\/span> for system, <span class=\"f_Command\">h<\/span> for hidden and <span class=\"f_Command\">r<\/span> for read-only.<\/p>\n\r<p class=\"p_Normal\">Examples:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">attrib +h<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">attrib +sh -a<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<hr style=\"height:2px; color:#000000; border-width:0; background-color:#000000;\" \/><p class=\"p_Normal\"><a id=\"beep\" class=\"hmanchor\"><\/a><span class=\"f_Subtitle\">BEEP<\/span><\/p>\n\r<p class=\"p_Normal\">Usage:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">beep<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">Beeps the PC speaker.  The beep occurs regardless of the <span class=\"f_CourierFixed\">\/silent<\/span> command line switch.<\/p>\n\r<hr style=\"height:2px; color:#000000; border-width:0; background-color:#000000;\" \/><p class=\"p_Normal\"><a id=\"collapse\" class=\"hmanchor\"><\/a><span class=\"f_Subtitle\">COLLAPSE<\/span><\/p>\n\r<p class=\"p_Normal\">Usage:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">collapse all<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">collapse &lt;<\/span><span class=\"f_CourierFixed\">path 1<\/span><span class=\"f_CourierFixed\">&gt; [&lt;<\/span><span class=\"f_CourierFixed\">path 2<\/span><span class=\"f_CourierFixed\">&gt; [...]]<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">Collapses all folders or folders with specified paths.  Paths are relative to the base folder and can <span style=\"font-style: italic;\">not<\/span> have wildcards.<\/p>\n\r<p class=\"p_Normal\">Example:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">collapse &quot;<\/span><span class=\"f_CourierFixed\">My Folder 1<\/span><span class=\"f_CourierFixed\">&quot; &quot;<\/span><span class=\"f_CourierFixed\">My Folder 2<\/span><span class=\"f_CourierFixed\">&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<hr style=\"height:2px; color:#000000; border-width:0; background-color:#000000;\" \/><p class=\"p_Normal\"><a id=\"compare\" class=\"hmanchor\"><\/a><span class=\"f_Subtitle\">COMPARE<\/span><\/p>\n\r<p class=\"p_Normal\">Usage:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">compare [CRC|binary|rules-based]<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">Compares the contents of the current selection using the <a href=\"opcompare.html\" class=\"topiclink\">compare type<\/a>.  By default, the most recent compare type is used.<\/p>\n\r<p class=\"p_Normal\">This command only compares files once.  To change how files are compared after modification, use <a href=\"scripting_reference.html#criteria\" class=\"topiclink\">CRITERIA<\/a>.<\/p>\n\r<hr style=\"height:2px; color:#000000; border-width:0; background-color:#000000;\" \/><p class=\"p_Normal\"><a id=\"copy\" class=\"hmanchor\"><\/a><span class=\"f_Subtitle\">COPY<\/span><\/p>\n\r<p class=\"p_Normal\">Usage:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">copy (left-&gt;right|right-&gt;left)<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">Copies the selected files\/folders in the direction indicated.<\/p>\n\r<hr style=\"height:2px; color:#000000; border-width:0; background-color:#000000;\" \/><p class=\"p_Normal\"><a id=\"copyto\" class=\"hmanchor\"><\/a><span class=\"f_Subtitle\">COPYTO<\/span><\/p>\n\r<p class=\"p_Normal\">Usage:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">copyto [left|right|all] [path:(relative|base|none)] &lt;<\/span><span class=\"f_CourierFixed\">path<\/span><span class=\"f_CourierFixed\">&gt;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">Copies the selected files\/folders on the specified side to the specified path using the <a href=\"opcopyto.html\" class=\"topiclink\">path option<\/a>.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">base<\/span> keeps the entire folder structure relative to the base folders of all selected items.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">relative<\/span> keeps the minimum relative folder structure of all selected items.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span>The defaults are <span class=\"f_Command\">all<\/span> and <span class=\"f_Command\">path:none<\/span>.<\/p>\n\r<p class=\"p_SingleSpaced\"><span class=\"f_SingleSpaced\">&nbsp;<\/span><\/p>\n\r<hr style=\"height:2px; color:#000000; border-width:0; background-color:#000000;\" \/><p class=\"p_Normal\"><a id=\"criteria\" class=\"hmanchor\"><\/a><span class=\"f_Subtitle\">CRITERIA<\/span><\/p>\n\r<p class=\"p_Normal\">Usage:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">criteria [attrib:&lt;<\/span><span class=\"f_CourierFixed\">attribute set<\/span><span class=\"f_CourierFixed\">&gt;] [version] [timestamp[:[&lt;<\/span><span class=\"f_CourierFixed\">number of seconds<\/span><span class=\"f_CourierFixed\">&gt;sec][;IgnoreDST]]] [size|CRC|binary|rules-based] [timezone:(ignore|(left|right)(+|-)&lt;0..12&gt;)] [follow-symlinks] [ignore-unimportant]<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">Where &lt;attribute set&gt; is:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">[a][s][h][r]<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\"><img style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/mac.png\"\/> <img style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/linux.png\"\/> The macOS and Linux versions do not support <span class=\"f_Command\">attrib<\/span>.<\/p>\n\r<p class=\"p_Normal\">Sets all <a href=\"sessiondircomparison.html\" class=\"topiclink\">comparison criteria<\/a> settings.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">attrib<\/span> enables comparisons of the specified DOS file attributes.  Use <span class=\"f_Command\">a<\/span> for archive, <span class=\"f_Command\">s<\/span> for system, <span class=\"f_Command\">h<\/span> for hidden and <span class=\"f_Command\">r<\/span> for read-only.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">version<\/span> enables comparisons of version information common in exes and dlls.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">timestamp<\/span> enables timestamp comparisons.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span>&lt;number of seconds&gt;<span class=\"f_Command\">sec<\/span> considers differences within a tolerance of seconds as matches.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_Command\">IgnoreDST<\/span> considers differences of exactly 1 hour as matches.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">size<\/span>, <span class=\"f_Command\">CRC<\/span>, <span class=\"f_Command\">binary<\/span> and <span class=\"f_Command\">rules-based<\/span> are the possible ways to compare contents.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">timezone<\/span> ignores timezone differences or applies timezone offset to the specified side.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">follow-symlinks<\/span> treats symbolic links and NTFS junctions as the target file or folder, rather than the link itself.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">ignore-unimportant<\/span> treats unimportant differences as matches.<\/p>\n\r<p class=\"p_Normal\">Example:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">criteria attrib:sh timestamp:2sec;IgnoreDST rules-based timezone:left+6<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<hr style=\"height:2px; color:#000000; border-width:0; background-color:#000000;\" \/><p class=\"p_Normal\"><a id=\"delete\" class=\"hmanchor\"><\/a><span class=\"f_Subtitle\">DELETE<\/span><\/p>\n\r<p class=\"p_Normal\">Usage:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">delete [recyclebin=(yes|no)] (left|right|all)<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">Deletes the currently selected files\/folders on the specified side(s).  The <span class=\"f_Command\">recyclebin<\/span> argument only has effect where supported by the operating system.  Network drives, remote services and archive files do not support it.<\/p>\n\r<hr style=\"height:2px; color:#000000; border-width:0; background-color:#000000;\" \/><p class=\"p_Normal\"><a id=\"expand\" class=\"hmanchor\"><\/a><span class=\"f_Subtitle\">EXPAND<\/span><\/p>\n\r<p class=\"p_Normal\">Usage:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">expand all<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">expand &lt;<\/span><span class=\"f_CourierFixed\">path 1<\/span><span class=\"f_CourierFixed\">&gt; [&lt;<\/span><span class=\"f_CourierFixed\">path 2<\/span><span class=\"f_CourierFixed\">&gt; [...]]<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">Expands specified subfolders or all subfolders.  Paths are relative to the base folder and can not have wildcards.  Subfolders must be expanded in order for their contents to be used by other commands, like <a href=\"scripting_reference.html#select\" class=\"topiclink\">SELECT<\/a>.  <span class=\"f_Command\">expand all<\/span> will not expand subfolders that have been excluded from the comparison by File Filter settings.<\/p>\n\r<hr style=\"height:2px; color:#000000; border-width:0; background-color:#000000;\" \/><p class=\"p_Normal\"><a id=\"file-report\" class=\"hmanchor\"><\/a><span class=\"f_Subtitle\">FILE-REPORT<\/span><\/p>\n\r<p class=\"p_Normal\">Usage:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">file-report layout:&lt;<\/span><span class=\"f_CourierFixed\">layout<\/span><span class=\"f_CourierFixed\">&gt; [options:&lt;<\/span><span class=\"f_CourierFixed\">options<\/span><span class=\"f_CourierFixed\">&gt;] [title:&lt;<\/span><span class=\"f_CourierFixed\">report title<\/span><span class=\"f_CourierFixed\">&gt;] output-to:(printer|clipboard|&lt;<\/span><span class=\"f_CourierFixed\">filename<\/span><span class=\"f_CourierFixed\">&gt;) [output-options:&lt;<\/span><span class=\"f_CourierFixed\">options<\/span><span class=\"f_CourierFixed\">&gt;] [&lt;<\/span><span class=\"f_CourierFixed\">comparison<\/span><span class=\"f_CourierFixed\">&gt;]<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">Generates a report of the currently selected files based on the type of files processed.  For example, it will produce a TABLE-REPORT for file types associated with a Table Compare file format.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">layout<\/span> controls the report\'s appearance and can be <span class=\"f_Command\">side-by-side<\/span> or <span class=\"f_Command\">summary<\/span>.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">options<\/span> is optional and is used differently for each layout.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_Command\">ignore-unimportant<\/span> treats differences in unimportant text as matches and is available in all layouts.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_Command\">display-all<\/span>, <span class=\"f_Command\">display-mismatches<\/span> or <span class=\"f_Command\">display-matches<\/span> can be used to control which lines of the comparison are included in all layouts except <span class=\"f_Command\">summary<\/span>.  By default, <span class=\"f_Command\">display-all<\/span> is used.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_Command\">line-numbers<\/span> includes line numbers in the <span class=\"f_Command\">side-by-side<\/span> layout.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">title<\/span>, <span class=\"f_Command\">output-to<\/span>, <span class=\"f_Command\">output-options<\/span> and &lt;comparison&gt; arguments are documented under <a href=\"scripting_reference.html#report_params\" class=\"topiclink\">Common Report Arguments<\/a>.<\/p>\n\r<p class=\"p_Normal\">Example:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">file-report layout:side-by-side options:display-mismatches &amp;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"> &nbsp; &nbsp;output-to:printer output-options:print-color,wrap-word<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<hr style=\"height:2px; color:#000000; border-width:0; background-color:#000000;\" \/><p class=\"p_Normal\"><a id=\"filter\" class=\"hmanchor\"><\/a><span class=\"f_Subtitle\">FILTER<\/span><\/p>\n\r<p class=\"p_Normal\">Usage:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">filter &lt;<\/span><span class=\"f_CourierFixed\">file masks<\/span><span class=\"f_CourierFixed\">&gt;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">filter cutoff:([&lt;|&gt;](&lt;<\/span><span class=\"f_CourierFixed\">timestamp<\/span><span class=\"f_CourierFixed\">&gt;|&lt;<\/span><span class=\"f_CourierFixed\">number of days<\/span><span class=\"f_CourierFixed\">&gt;[days])|none)<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">filter attrib:((+|-)&lt;<\/span><span class=\"f_CourierFixed\">attribute set<\/span><span class=\"f_CourierFixed\">&gt;|none)<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">filter size:([&lt;|&gt;]&lt;<\/span><span class=\"f_CourierFixed\">number<\/span><span class=\"f_CourierFixed\">&gt;[KB|MB|GB|TB]|none)<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">filter exclude-protected<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">filter include-protected<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">Where &lt;attribute set&gt; is:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">[a][s][h][r]<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\"><img style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/mac.png\"\/> <img style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/linux.png\"\/> The macOS and Linux versions do not support <span class=\"f_Command\">attrib<\/span>, <span class=\"f_Command\">exclude-protected<\/span> or <span class=\"f_Command\">include-protected<\/span>.<\/p>\n\r<p class=\"p_Normal\">Controls which folders and types of files are compared by using name filtering (<a href=\"file_masks.html\" class=\"topiclink\">file masks<\/a>), date filtering (<span class=\"f_Command\">cutoff<\/span>) or other filtering (<span class=\"f_Command\">attrib<\/span>, <span class=\"f_Command\">size<\/span>, <span class=\"f_Command\">exclude-protected<\/span> or <span class=\"f_Command\">include-protected<\/span>).<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span>Name filters include and exclude files and folders based on their names and paths.  Multiple masks can be separated by semicolons.  To indicate that a mask is an exclude mask use a leading minus (-).  To indicate that a mask affects folders use a trailing backslash (\\).<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">cutoff<\/span> excludes all files older (<span class=\"f_Command\">&lt;<\/span>) or newer (<span class=\"f_Command\">&gt;<\/span>) than a timestamp or a number of days from the current system date (&lt;number of days&gt;<span class=\"f_Command\">days<\/span>).  By default, <span class=\"f_Command\">cutoff:&lt;<\/span> is used.  <span class=\"f_Command\">none<\/span> can be used to remove date filtering.  The date parsing is fairly lenient but if you want to be sure it parses correctly, use the format specified by the operating system\'s regional settings.  (See <span class=\"f_Command\">Control Panel &gt; Regional and Language Settings<\/span>.)  The time is optional and should follow the date (cutoff:&quot;12\/31\/2012 12:00pm&quot;).  Remember to use quotation marks (&quot; &quot;) whenever a term contains a space.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">attrib<\/span> limits the comparison to files which have an included DOS file attribute (<span class=\"f_Command\">+<\/span>) and don\'t have an excluded attribute (<span class=\"f_Command\">-<\/span>).  Use <span class=\"f_Command\">a<\/span> for archive, <span class=\"f_Command\">s<\/span> for system, <span class=\"f_Command\">h<\/span> for hidden and <span class=\"f_Command\">r<\/span> for read-only.  <span class=\"f_Command\">none<\/span> can be used to remove attribute filtering.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">size<\/span> excludes all files smaller (<span class=\"f_Command\">&lt;<\/span>) or larger (<span class=\"f_Command\">&gt;<\/span>) than the given size.  By default the size is given in bytes but you can add <span class=\"f_Command\">KB<\/span>, <span class=\"f_Command\">MB<\/span>, <span class=\"f_Command\">GB<\/span> or <span class=\"f_Command\">TB<\/span> to the end to indicate that the value is in kilobytes, megabytes, gigabytes or terabytes, respectively.  <span class=\"f_Command\">none<\/span> can be used to remove size filtering.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">exclude-protected<\/span> excludes files and folders that have both system and hidden attributes set.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">include-protected<\/span> includes files and folders that have both system and hidden attributes set.<\/p>\n\r<p class=\"p_Normal\">Examples:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">filter &quot;*.pas;*.dpr;*.dfm&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">filter cutoff:&lt;7days<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">filter cutoff:&gt;&quot;Dec 31, 2012&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">filter cutoff:&quot;12\/31\/2012 12:00pm&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">filter attrib:-sh<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">filter &quot;*.txt;-<\/span><span class=\"f_CourierFixed\">My Folder<\/span><span class=\"f_CourierFixed\">\\&quot; attrib:+r<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<hr style=\"height:2px; color:#000000; border-width:0; background-color:#000000;\" \/><p class=\"p_Normal\"><a id=\"folder-report\" class=\"hmanchor\"><\/a><span class=\"f_Subtitle\">FOLDER-REPORT<\/span><\/p>\n\r<p class=\"p_Normal\">Usage:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">folder-report layout:&lt;<\/span><span class=\"f_CourierFixed\">layout<\/span><span class=\"f_CourierFixed\">&gt; [options:&lt;<\/span><span class=\"f_CourierFixed\">options<\/span><span class=\"f_CourierFixed\">&gt;] [title:&lt;<\/span><span class=\"f_CourierFixed\">report title<\/span><span class=\"f_CourierFixed\">&gt;] output-to:(printer|clipboard|&lt;<\/span><span class=\"f_CourierFixed\">filename<\/span><span class=\"f_CourierFixed\">&gt;) [output-options:&lt;<\/span><span class=\"f_CourierFixed\">options<\/span><span class=\"f_CourierFixed\">&gt;]<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">Generates a folder comparison report of the currently loaded base folders.  Folders are shown in their current state.  To include subfolders add an <span class=\"f_Command\">expand all<\/span> command before this.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">layout<\/span> controls the report\'s appearance and can be <span class=\"f_Command\">side-by-side<\/span>, <span class=\"f_Command\">summary<\/span> or <span class=\"f_Command\">xml<\/span>.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">options<\/span> is optional.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span>Display filter flags control which files are included in the report.  The possible values are <span class=\"f_Command\">display-all<\/span>, <span class=\"f_Command\">display-mismatches<\/span>, <span class=\"f_Command\">display-no-orphans<\/span>, <span class=\"f_Command\">display-mismatches-no-orphans<\/span>, <span class=\"f_Command\">display-orphans<\/span>, <span class=\"f_Command\">display-left-newer<\/span>, <span class=\"f_Command\">display-right-newer<\/span>, <span class=\"f_Command\">display-left-newer-orphans<\/span>, <span class=\"f_Command\">display-right-newer-orphans<\/span>, <span class=\"f_Command\">display-left-orphans<\/span>, <span class=\"f_Command\">display-right-orphans<\/span> and <span class=\"f_Command\">display-matches<\/span>.  By default, <span class=\"f_Command\">display-all<\/span> is used.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span>Optional columns can be included, separated by commas, in the report by using the flags <span class=\"f_Command\">column-version<\/span>, <span class=\"f_Command\">column-size<\/span>, <span class=\"f_Command\">column-crc<\/span>, <span class=\"f_Command\">column-timestamp<\/span>, <span class=\"f_Command\">column-attributes<\/span>, <span class=\"f_Command\">column-group<\/span>, <span class=\"f_Command\">column-owner<\/span> and <span class=\"f_Command\">column-vcs<\/span>.  By default, <span class=\"f_Command\">column-size<\/span> and <span class=\"f_Command\">column-timestamp<\/span> are included.  <span class=\"f_Command\">column-none<\/span> can be used by itself to clear the default columns.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span>Use the flag <span class=\"f_Command\">include-file-links<\/span> to generate file reports and include links to them in the folder report.  Only a folder report that is both side-by-side and HTML can use this flag.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">title<\/span>, <span class=\"f_Command\">output-to<\/span> and <span class=\"f_Command\">output-options<\/span> arguments are documented under <a href=\"scripting_reference.html#report_params\" class=\"topiclink\">Common Report Arguments<\/a>.<\/p>\n\r<p class=\"p_Normal\">Examples:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">folder-report layout:side-by-side &amp;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"> &nbsp; &nbsp;options:column-size,column-version,column-timestamp &amp;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"> &nbsp; &nbsp;output-to:clipboard output-options:html-color<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">folder-report layout:xml output-to:&quot;C:\\<\/span><span class=\"f_CourierFixed\">My Report<\/span><span class=\"f_CourierFixed\">.xml&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<hr style=\"height:2px; color:#000000; border-width:0; background-color:#000000;\" \/><p class=\"p_Normal\"><a id=\"hex-report\" class=\"hmanchor\"><\/a><span class=\"f_Subtitle\">HEX-REPORT<\/span><\/p>\n\r<p class=\"p_Normal\">Usage:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">hex-report layout:&lt;<\/span><span class=\"f_CourierFixed\">layout<\/span><span class=\"f_CourierFixed\">&gt; [options:&lt;<\/span><span class=\"f_CourierFixed\">options<\/span><span class=\"f_CourierFixed\">&gt;] [title:&lt;<\/span><span class=\"f_CourierFixed\">report title<\/span><span class=\"f_CourierFixed\">&gt;] output-to:(printer|clipboard|&lt;<\/span><span class=\"f_CourierFixed\">filename<\/span><span class=\"f_CourierFixed\">&gt;) [output-options:&lt;<\/span><span class=\"f_CourierFixed\">options<\/span><span class=\"f_CourierFixed\">&gt;] [&lt;<\/span><span class=\"f_CourierFixed\">comparison<\/span><span class=\"f_CourierFixed\">&gt;]<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">Generates a Hex Compare report of the currently selected files.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">layout<\/span> controls the report\'s appearance and can be <span class=\"f_Command\">side-by-side<\/span>, <span class=\"f_Command\">summary<\/span> or <span class=\"f_Command\">interleaved<\/span>.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">options<\/span> is optional and is used differently for each layout.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_Command\">display-all<\/span>, <span class=\"f_Command\">display-mismatches<\/span> or <span class=\"f_Command\">display-matches<\/span> can be used to control which lines of the comparison are included in all layouts except <span class=\"f_Command\">summary<\/span>.  By default, <span class=\"f_Command\">display-all<\/span> is used.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_Command\">line-numbers<\/span> includes byte addresses in the <span class=\"f_Command\">side-by-side<\/span> layout.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">title<\/span>, <span class=\"f_Command\">output-to<\/span>, <span class=\"f_Command\">output-options<\/span> and &lt;comparison&gt; arguments are documented under <a href=\"scripting_reference.html#report_params\" class=\"topiclink\">Common Report Arguments<\/a>.<\/p>\n\r<hr style=\"height:2px; color:#000000; border-width:0; background-color:#000000;\" \/><p class=\"p_Normal\"><a id=\"load\" class=\"hmanchor\"><\/a><span class=\"f_Subtitle\">LOAD<\/span><\/p>\n\r<p class=\"p_Normal\">Usage:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">load &lt;<\/span><span class=\"f_CourierFixed\">session<\/span><span class=\"f_CourierFixed\">&gt;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">load [create:(all|left|right)] &lt;<\/span><span class=\"f_CourierFixed\">left path<\/span><span class=\"f_CourierFixed\">&gt; [&lt;<\/span><span class=\"f_CourierFixed\">right path<\/span><span class=\"f_CourierFixed\">&gt;]<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">load &lt;default&gt;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">Loads the specified Folder Compare session, the specified base folders or a new Folder Compare session with default settings (<span class=\"f_Command\">load &lt;default&gt;<\/span>).  Failure to load a base folder will cause the script to terminate.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span>Loading a session causes all that session\'s settings, except the display filter (show all, only mismatches, only matches, etc.), to be used.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span>Loading base folders uses the currently active settings.  By default, the <span style=\"font-style: italic;\">program defaults<\/span> are used.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span>The optional <span class=\"f_Command\">create<\/span> parameter creates a base folder if it doesn\'t already exist.<\/p>\n\r<p class=\"p_Normal\">Examples:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">load &quot;<\/span><span class=\"f_CourierFixed\">My Session<\/span><span class=\"f_CourierFixed\">&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">load &quot;C:\\<\/span><span class=\"f_CourierFixed\">My Folder<\/span><span class=\"f_CourierFixed\">&quot; &quot;X:\\<\/span><span class=\"f_CourierFixed\">Your Folder<\/span><span class=\"f_CourierFixed\">&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">load &lt;default&gt;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<hr style=\"height:2px; color:#000000; border-width:0; background-color:#000000;\" \/><p class=\"p_Normal\"><a id=\"log\" class=\"hmanchor\"><\/a><span class=\"f_Subtitle\">LOG<\/span><\/p>\n\r<p class=\"p_Normal\">Usage:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">log [none|normal|verbose] [[append:]&lt;<\/span><span class=\"f_CourierFixed\">filename<\/span><span class=\"f_CourierFixed\">&gt;]<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">Controls how detailed the log is and where the log is stored.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">none<\/span>, <span class=\"f_Command\">normal<\/span> and <span class=\"f_Command\">verbose<\/span> determine the amount of detail used in the log.  Logging is initially disabled and begins when the mode is changed from <span class=\"f_Command\">none<\/span>.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">append:<\/span> causes logging to add to the file instead of replace it.  By default, the log is output as Log.txt in the current folder (e.g. the Windows &quot;Start In&quot; folder in shortcut properties).<\/p>\n\r<hr style=\"height:2px; color:#000000; border-width:0; background-color:#000000;\" \/><p class=\"p_Normal\"><a id=\"media-report\" class=\"hmanchor\"><\/a><span class=\"f_Subtitle\">MEDIA-REPORT<\/span><\/p>\n\r<p class=\"p_Normal\">Usage:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">media-report layout:&lt;<\/span><span class=\"f_CourierFixed\">layout<\/span><span class=\"f_CourierFixed\">&gt; [options:&lt;<\/span><span class=\"f_CourierFixed\">options<\/span><span class=\"f_CourierFixed\">&gt;] [title:&lt;<\/span><span class=\"f_CourierFixed\">report title<\/span><span class=\"f_CourierFixed\">&gt;] output-to:(printer|clipboard|&lt;<\/span><span class=\"f_CourierFixed\">filename<\/span><span class=\"f_CourierFixed\">&gt;) [output-options:&lt;<\/span><span class=\"f_CourierFixed\">options<\/span><span class=\"f_CourierFixed\">&gt;] [&lt;<\/span><span class=\"f_CourierFixed\">comparison<\/span><span class=\"f_CourierFixed\">&gt;]<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">Generates an Media Compare report of the currently selected files.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">layout<\/span> controls the report\'s appearance and can be <span class=\"f_Command\">side-by-side<\/span> or <span class=\"f_Command\">summary<\/span>.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">options<\/span> is optional and is used differently for each layout.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_Command\">ignore-unimportant<\/span> treats differences in unimportant text as matches and is available in all layouts.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_Command\">display-all<\/span>, <span class=\"f_Command\">display-mismatches<\/span> or <span class=\"f_Command\">display-matches<\/span> can be used to control which lines of the comparison are included in all layouts except <span class=\"f_Command\">summary<\/span>.  By default, <span class=\"f_Command\">display-all<\/span> is used.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">title<\/span>, <span class=\"f_Command\">output-to<\/span>, <span class=\"f_Command\">output-options<\/span> and &lt;comparison&gt; arguments are documented under <a href=\"scripting_reference.html#report_params\" class=\"topiclink\">Common Report Arguments<\/a>.<\/p>\n\r<hr style=\"height:2px; color:#000000; border-width:0; background-color:#000000;\" \/><p class=\"p_Normal\"><a id=\"move\" class=\"hmanchor\"><\/a><span class=\"f_Subtitle\">MOVE<\/span><\/p>\n\r<p class=\"p_Normal\">Usage:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">move (left-&gt;right|right-&gt;left)<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">Moves the selected files\/folders in the direction specified.<\/p>\n\r<hr style=\"height:2px; color:#000000; border-width:0; background-color:#000000;\" \/><p class=\"p_Normal\"><a id=\"moveto\" class=\"hmanchor\"><\/a><span class=\"f_Subtitle\">MOVETO<\/span><\/p>\n\r<p class=\"p_Normal\">Usage:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">moveto [left|right|all] [path:(relative|base|none)] &lt;<\/span><span class=\"f_CourierFixed\">path<\/span><span class=\"f_CourierFixed\">&gt;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">Moves the selected files\/folders on the specified side to the specified path using the <a href=\"opmoveto.html\" class=\"topiclink\">path option<\/a>.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">base<\/span> keeps the entire folder structure relative to the base folders of all selected items.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">relative<\/span> keeps the minimum relative folder structure of all selected items.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span>The defaults are <span class=\"f_Command\">all<\/span> and <span class=\"f_Command\">path:none<\/span>.<\/p>\n\r<p class=\"p_SingleSpaced\"><span class=\"f_SingleSpaced\">&nbsp;<\/span><\/p>\n\r<hr style=\"height:2px; color:#000000; border-width:0; background-color:#000000;\" \/><p class=\"p_Normal\"><a id=\"option\" class=\"hmanchor\"><\/a><span class=\"f_Subtitle\">OPTION<\/span><\/p>\n\r<p class=\"p_Normal\">Usage:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">option stop-on-error<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">option confirm:(prompt|yes-to-all|no-to-all)<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">Adjusts script processing options.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">stop-on-error<\/span> makes the script watch for various error conditions, including file operation errors, and, when one occurs, prompts the user before continuing.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">confirm<\/span> can use <span class=\"f_Command\">prompt<\/span>, <span class=\"f_Command\">yes-to-all<\/span> or <span class=\"f_Command\">no-to-all<\/span> to handle confirmation dialogs that occur due to file operations.  By default, <span class=\"f_Command\">prompt<\/span> is used.<\/p>\n\r<hr style=\"height:2px; color:#000000; border-width:0; background-color:#000000;\" \/><p class=\"p_Normal\"><a id=\"pix-report\" class=\"hmanchor\"><\/a><span class=\"f_Subtitle\">PICTURE-REPORT<\/span><\/p>\n\r<p class=\"p_Normal\">Usage:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">picture-report layout:&lt;<\/span><span class=\"f_CourierFixed\">layout<\/span><span class=\"f_CourierFixed\">&gt; [options:&lt;<\/span><span class=\"f_CourierFixed\">options<\/span><span class=\"f_CourierFixed\">&gt;] [title:&lt;<\/span><span class=\"f_CourierFixed\">report title<\/span><span class=\"f_CourierFixed\">&gt;] output-to:(printer|clipboard|&lt;<\/span><span class=\"f_CourierFixed\">filename<\/span><span class=\"f_CourierFixed\">&gt;) [output-options:&lt;<\/span><span class=\"f_CourierFixed\">options<\/span><span class=\"f_CourierFixed\">&gt;] [&lt;<\/span><span class=\"f_CourierFixed\">comparison<\/span><span class=\"f_CourierFixed\">&gt;]<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">Generates a Picture Compare report of the currently selected files.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">layout<\/span> controls the report\'s appearance and can be <span class=\"f_Command\">side-by-side<\/span> or <span class=\"f_Command\">summary<\/span>.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">options<\/span> is optional and is used differently for each layout.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_Command\">ignore-unimportant<\/span> treats differences in unimportant text as matches in the <span class=\"f_Command\">summary<\/span> layout.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">title<\/span>, <span class=\"f_Command\">output-to<\/span>, <span class=\"f_Command\">output-options<\/span> and &lt;comparison&gt; arguments are documented under <a href=\"scripting_reference.html#report_params\" class=\"topiclink\">Common Report Arguments<\/a>.<\/p>\n\r<hr style=\"height:2px; color:#000000; border-width:0; background-color:#000000;\" \/><p class=\"p_Normal\"><a id=\"reg-report\" class=\"hmanchor\"><\/a><span class=\"f_Subtitle\">REGISTRY-REPORT<\/span> <img style=\"margin:0;width:1.6875rem;height:0.7500rem;border:none\" src=\".\/images\/pro.png\"\/> <img style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/windows.png\"\/><\/p>\n\r<p class=\"p_Normal\">Usage:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">registry-report layout:&lt;<\/span><span class=\"f_CourierFixed\">layout<\/span><span class=\"f_CourierFixed\">&gt; [options:&lt;<\/span><span class=\"f_CourierFixed\">options<\/span><span class=\"f_CourierFixed\">&gt;] [title:&lt;<\/span><span class=\"f_CourierFixed\">report title<\/span><span class=\"f_CourierFixed\">&gt;] output-to:(printer|clipboard|&lt;<\/span><span class=\"f_CourierFixed\">filename<\/span><span class=\"f_CourierFixed\">&gt;) [output-options:&lt;<\/span><span class=\"f_CourierFixed\">options<\/span><span class=\"f_CourierFixed\">&gt;] [&lt;<\/span><span class=\"f_CourierFixed\">comparison<\/span><span class=\"f_CourierFixed\">&gt;]<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">Generates a Registry Compare report of the currently selected files.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">layout<\/span> controls the report\'s appearance and can be <span class=\"f_Command\">side-by-side<\/span> or <span class=\"f_Command\">summary<\/span>.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">options<\/span> is optional and is used differently for each layout.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_Command\">display-all<\/span>, <span class=\"f_Command\">display-mismatches<\/span> or <span class=\"f_Command\">display-matches<\/span> can be used to control which lines of the comparison are included in all layouts except <span class=\"f_Command\">summary<\/span>.  By default, <span class=\"f_Command\">display-all<\/span> is used.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">title<\/span>, <span class=\"f_Command\">output-to<\/span>, <span class=\"f_Command\">output-options<\/span> and &lt;comparison&gt; arguments are documented under <a href=\"scripting_reference.html#report_params\" class=\"topiclink\">Common Report Arguments<\/a>.<\/p>\n\r<hr style=\"height:2px; color:#000000; border-width:0; background-color:#000000;\" \/><p class=\"p_Normal\"><a id=\"rename\" class=\"hmanchor\"><\/a><span class=\"f_Subtitle\">RENAME<\/span><\/p>\n\r<p class=\"p_Normal\">Usage:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">rename [regexpr &lt;<\/span><span class=\"f_CourierFixed\">old mask<\/span><span class=\"f_CourierFixed\">&gt;] &lt;<\/span><span class=\"f_CourierFixed\">new mask<\/span><span class=\"f_CourierFixed\">&gt;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">Performs a <a href=\"oprename.html\" class=\"topiclink\">multi-file rename<\/a> on the current selection using the specified new mask.  <span class=\"f_Command\">regexpr<\/span> uses an old mask to perform a regular expression rename.  By default, a DOS-style rename is performed.<\/p>\n\r<p class=\"p_Normal\">Examples:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">rename *.bak<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">rename regexpr (...)(...)\\.txt \$2\$1.txt<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<hr style=\"height:2px; color:#000000; border-width:0; background-color:#000000;\" \/><p class=\"p_Normal\"><a id=\"select\" class=\"hmanchor\"><\/a><span class=\"f_Subtitle\">SELECT<\/span><\/p>\n\r<p class=\"p_Normal\">Usage:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">select &lt;<\/span><span class=\"f_CourierFixed\">selection mask 1<\/span><span class=\"f_CourierFixed\">&gt; [&lt;<\/span><span class=\"f_CourierFixed\">selection mask 2<\/span><span class=\"f_CourierFixed\">&gt; [...]]<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">Where &lt;selection mask&gt; is one of the following:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">all<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">[(left|right|all).][(exact|diff|newer|older|orphan|all).][(files|folders|all)]<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">empty.folders<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">Select controls which files and folders can be operated on.  Only files and folders that match at least one of the selection masks are part of the selection.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">left<\/span>, <span class=\"f_Command\">right<\/span> or <span class=\"f_Command\">all<\/span> limits the selection to the specified side.  By default, <span class=\"f_Command\">all<\/span> is used.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">exact<\/span>, <span class=\"f_Command\">diff<\/span>, <span class=\"f_Command\">newer<\/span>, <span class=\"f_Command\">older<\/span>, <span class=\"f_Command\">orphan<\/span> or <span class=\"f_Command\">all<\/span> limits the selection based on results of comparison.  <span class=\"f_Command\">diff<\/span> refers to differences in criteria other than timestamps.  To compare timestamps use <span class=\"f_Command\">newer<\/span> or <span class=\"f_Command\">older<\/span> instead.  Folders must contain only the specified result type to be affected.  By default, <span class=\"f_Command\">all<\/span> is used.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">files<\/span>, <span class=\"f_Command\">folders<\/span> or <span class=\"f_Command\">all<\/span> limits the selection to files, folders or both.  By default, <span class=\"f_Command\">all<\/span> is used.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">empty.folders<\/span> is a special selection mask that will select empty folders.<\/p>\n\r<p class=\"p_Normal\">Examples:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">select all<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">select left<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">select exact<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">select files<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">select right.diff<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">select left.folders<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">select newer.files right.older.files<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<hr style=\"height:2px; color:#000000; border-width:0; background-color:#000000;\" \/><p class=\"p_Normal\"><a id=\"snapshot\" class=\"hmanchor\"><\/a><span class=\"f_Subtitle\">SNAPSHOT<\/span><\/p>\n\r<p class=\"p_Normal\">Usage:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">snapshot [save-crc] [save-version] [expand-archives] [follow-symlinks] [include-empty] [no-filters] left|right|path:&lt;<\/span><span class=\"f_CourierFixed\">path<\/span><span class=\"f_CourierFixed\">&gt; [output:&lt;<\/span><span class=\"f_CourierFixed\">target<\/span><span class=\"f_CourierFixed\">&gt;]<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">Saves a read-only snapshot of the specified folder.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">save-crc<\/span> calculates CRC\'s for all files and stores them as part of the snapshot.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">save-version<\/span> stores version information for executable files.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">expand-archives<\/span> stores the contents of archive files in an expanded format.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">follow-symlinks<\/span> stores files and folders pointed to by symbolic links.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">include-empty<\/span> stores folders that are empty or contain only excluded files.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">no-filters<\/span> stores all files regardless of the active filename filters.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">left<\/span>, <span class=\"f_Command\">right<\/span> and <span class=\"f_Command\">path<\/span> indicate which folder is stored.  <span class=\"f_Command\">left<\/span> or <span class=\"f_Command\">right<\/span> will save a snapshot of one of the loaded base folders and <span class=\"f_Command\">path<\/span> will save a snapshot of a specified path.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">output<\/span> is optional and determines where the snapshot will be saved.  By default, it will be saved in the current folder.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span>If target is a fully qualified filename, that will be the name of the snapshot.  If target doesn\'t have an extension, <span class=\"f_Command\">.bcss<\/span> will be used.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span>If the target isn\'t included or refers to a folder a filename will be generated based on the source folder\'s name and the current system date, eg <span class=\"f_CourierFixed\">folder_2012-12-31.bcss<\/span>.  If necessary an additional number will be added to the generated name to keep it from overwriting existing snapshots.<\/p>\n\r<p class=\"p_Normal\">Examples:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">snapshot save-crc save-version no-filters path:C:\\ output:D:\\<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">snapshot left output:&quot;<\/span><span class=\"f_CourierFixed\">My Snapshot<\/span><span class=\"f_CourierFixed\">.bcss&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<hr style=\"height:2px; color:#000000; border-width:0; background-color:#000000;\" \/><p class=\"p_Normal\"><a id=\"sync\" class=\"hmanchor\"><\/a><span class=\"f_Subtitle\">SYNC<\/span><\/p>\n\r<p class=\"p_Normal\">Usage:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">sync [visible] [create-empty] (update|mirror):(left-&gt;right|right-&gt;left|all)<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">Synchronizes folders by copying and deleting files.  This command <span style=\"font-style: italic;\">does not<\/span> use the current selection.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">visible<\/span> enables &quot;Only affect visible files&quot; behavior.  Only files in expanded folders will be affected.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">create-empty<\/span> enables the &quot;Create empty folders&quot; behavior.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">update<\/span> copies newer and orphan files in the indicated direction, leaving orphans and newer files on the opposite side unchanged.  Using <span class=\"f_Command\">all<\/span> as the direction indicates a bidirectional sync and copies newer and orphan files in both directions.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">mirror<\/span> makes the target folder identical to the source one.  Newer, older, different and orphaned files are all copied to the destination.  Orphans in the destination are deleted.  The <span class=\"f_Command\">all<\/span> direction doesn\'t apply in this context and is not valid.<\/p>\n\r<p class=\"p_Normal\">Example:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">sync create-empty mirror:left-&gt;right<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<hr style=\"height:2px; color:#000000; border-width:0; background-color:#000000;\" \/><p class=\"p_Normal\"><a id=\"table-report\" class=\"hmanchor\"><\/a><span class=\"f_Subtitle\">TABLE-REPORT<\/span><\/p>\n\r<p class=\"p_Normal\">Usage:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">data-report layout:&lt;<\/span><span class=\"f_CourierFixed\">layout<\/span><span class=\"f_CourierFixed\">&gt; [options:&lt;<\/span><span class=\"f_CourierFixed\">options<\/span><span class=\"f_CourierFixed\">&gt;] [title:&lt;<\/span><span class=\"f_CourierFixed\">report title<\/span><span class=\"f_CourierFixed\">&gt;] output-to:(printer|clipboard|&lt;<\/span><span class=\"f_CourierFixed\">filename<\/span><span class=\"f_CourierFixed\">&gt;) [output-options:&lt;<\/span><span class=\"f_CourierFixed\">options<\/span><span class=\"f_CourierFixed\">&gt;] [&lt;<\/span><span class=\"f_CourierFixed\">comparison<\/span><span class=\"f_CourierFixed\">&gt;]<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">Generates a Table Compare report of the currently selected files.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">layout<\/span> controls the report\'s appearance and can be <span class=\"f_Command\">side-by-side<\/span>, <span class=\"f_Command\">summary<\/span> or <span class=\"f_Command\">interleaved<\/span>.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">options<\/span> is optional and is used differently for each layout.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_Command\">ignore-unimportant<\/span> treats differences in unimportant text as matches and is available in all layouts.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_Command\">display-all<\/span>, <span class=\"f_Command\">display-mismatches<\/span> or <span class=\"f_Command\">display-matches<\/span> can be used to control which lines of the comparison are included in all layouts except <span class=\"f_Command\">summary<\/span>.  By default, <span class=\"f_Command\">display-all<\/span> is used.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_Command\">line-numbers<\/span> includes row numbers in the <span class=\"f_Command\">side-by-side<\/span> layout.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">title<\/span>, <span class=\"f_Command\">output-to<\/span>, <span class=\"f_Command\">output-options<\/span> and &lt;comparison&gt; arguments are documented under <a href=\"scripting_reference.html#report_params\" class=\"topiclink\">Common Report Arguments<\/a>.<\/p>\n\r<hr style=\"height:2px; color:#000000; border-width:0; background-color:#000000;\" \/><p class=\"p_Normal\"><a id=\"text-report\" class=\"hmanchor\"><\/a><span class=\"f_Subtitle\">TEXT-REPORT<\/span><\/p>\n\r<p class=\"p_Normal\">Usage:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">text-report layout:&lt;<\/span><span class=\"f_CourierFixed\">layout<\/span><span class=\"f_CourierFixed\">&gt; [options:&lt;<\/span><span class=\"f_CourierFixed\">options<\/span><span class=\"f_CourierFixed\">&gt;] [title:&lt;<\/span><span class=\"f_CourierFixed\">report title<\/span><span class=\"f_CourierFixed\">&gt;] output-to:(printer|clipboard|&lt;<\/span><span class=\"f_CourierFixed\">filename<\/span><span class=\"f_CourierFixed\">&gt;) [output-options:&lt;<\/span><span class=\"f_CourierFixed\">options<\/span><span class=\"f_CourierFixed\">&gt;] [&lt;<\/span><span class=\"f_CourierFixed\">comparison<\/span><span class=\"f_CourierFixed\">&gt;]<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">Generates a Text Compare report of the currently selected files.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">layout<\/span> controls the report\'s appearance and can be <span class=\"f_Command\">side-by-side<\/span>, <span class=\"f_Command\">summary<\/span>, <span class=\"f_Command\">interleaved<\/span>, <span class=\"f_Command\">patch<\/span>, <span class=\"f_Command\">statistics<\/span> or <span class=\"f_Command\">xml<\/span>.  Deprecated layouts <span class=\"f_Command\">over-under<\/span> and <span class=\"f_Command\">composite<\/span> have been replaced by <span class=\"f_Command\">interleaved<\/span>.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">options<\/span> is optional and is used differently for each layout.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_Command\">ignore-unimportant<\/span> treats differences in unimportant text as matches and is available in all layouts.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_Command\">display-all<\/span>, <span class=\"f_Command\">display-mismatches<\/span>, <span class=\"f_Command\">display-context<\/span> or <span class=\"f_Command\">display-matches<\/span> can be used to control which lines of the comparison are included in all layouts except <span class=\"f_Command\">summary<\/span>, <span class=\"f_Command\">patch<\/span> and <span class=\"f_Command\">statistics<\/span>.  By default, <span class=\"f_Command\">display-all<\/span> is used.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_Command\">line-numbers<\/span> includes line numbers in the <span class=\"f_Command\">side-by-side<\/span> layout.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_Command\">strikeout-left-diffs<\/span> crosses out left difference lines in the <span class=\"f_Command\">interleaved<\/span> layout.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_Command\">strikeout-right-diffs<\/span> crosses out right difference lines in the <span class=\"f_Command\">interleaved<\/span> layout.<\/p>\n\r<p style=\"text-indent: 0; padding-left: 1.6250rem; margin: 0 0 0 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_Command\">patch-normal<\/span>, <span class=\"f_Command\">patch-context<\/span> or <span class=\"f_Command\">patch-unified<\/span> formats are available in the <span class=\"f_Command\">patch<\/span> layout.  By default, <span class=\"f_Command\">patch-normal<\/span> is used.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">title<\/span>, <span class=\"f_Command\">output-to<\/span>, <span class=\"f_Command\">output-options<\/span> and &lt;comparison&gt; arguments are documented under <a href=\"scripting_reference.html#report_params\" class=\"topiclink\">Common Report Arguments<\/a>.<\/p>\n\r<p class=\"p_Normal\">The deprecated <span class=\"f_Command\">stats-descriptive<\/span> option will generate a summary report instead and post a warning to the log.  The deprecated <span class=\"f_Command\">stats-tabular<\/span> option is ignored in the <span class=\"f_Command\">statistics<\/span> layout: the <span class=\"f_Command\">statistics<\/span> layout is always tabular (CSV) now.<\/p>\n\r<p class=\"p_Normal\">Examples:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">text-report layout:interleaved options:display-context &amp;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"> &nbsp; &nbsp;output-to:printer output-options:print-color,wrap-word<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">text-report layout:patch options:patch-unified &amp;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"> &nbsp; &nbsp;output-to:&quot;<\/span><span class=\"f_CourierFixed\">My Report<\/span><span class=\"f_CourierFixed\">.txt&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<hr style=\"height:2px; color:#000000; border-width:0; background-color:#000000;\" \/><p class=\"p_Normal\"><a id=\"touch\" class=\"hmanchor\"><\/a><span class=\"f_Subtitle\">TOUCH<\/span><\/p>\n\r<p class=\"p_Normal\">Usage:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">touch (left-&gt;right|right-&gt;left)<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">touch (left|right|all):(now|&lt;<\/span><span class=\"f_CourierFixed\">timestamp<\/span><span class=\"f_CourierFixed\">&gt;)<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">Copies the timestamps from files on one side to the other or sets the timestamps of all files on a specified side to the current system time (<span class=\"f_Command\">now<\/span>) or a specified timestamp.  You must select files before you can touch them.<\/p>\n\r<hr style=\"height:2px; color:#000000; border-width:0; background-color:#000000;\" \/><p class=\"p_Normal\"><a id=\"version-report\" class=\"hmanchor\"><\/a><span class=\"f_Subtitle\">VERSION-REPORT<\/span> <img style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/windows.png\"\/><\/p>\n\r<p class=\"p_Normal\">Usage:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">version-report layout:&lt;<\/span><span class=\"f_CourierFixed\">layout<\/span><span class=\"f_CourierFixed\">&gt; [options:&lt;<\/span><span class=\"f_CourierFixed\">options<\/span><span class=\"f_CourierFixed\">&gt;] [title:&lt;<\/span><span class=\"f_CourierFixed\">report title<\/span><span class=\"f_CourierFixed\">&gt;] output-to:(printer|clipboard|&lt;<\/span><span class=\"f_CourierFixed\">filename<\/span><span class=\"f_CourierFixed\">&gt;) [output-options:&lt;<\/span><span class=\"f_CourierFixed\">options<\/span><span class=\"f_CourierFixed\">&gt;] [&lt;<\/span><span class=\"f_CourierFixed\">comparison<\/span><span class=\"f_CourierFixed\">&gt;]<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">Generates a Version Compare report of the currently selected files.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">layout<\/span> controls the report\'s appearance and can be <span class=\"f_Command\">side-by-side<\/span> or <span class=\"f_Command\">summary<\/span>.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">options<\/span> is optional and is used differently for each layout.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_Command\">ignore-unimportant<\/span> treats differences in unimportant text as matches and is available in all layouts.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_Command\">display-all<\/span>, <span class=\"f_Command\">display-mismatches<\/span> or <span class=\"f_Command\">display-matches<\/span> can be used to control which lines of the comparison are included in all layouts except <span class=\"f_Command\">summary<\/span>.  By default, <span class=\"f_Command\">display-all<\/span> is used.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">title<\/span>, <span class=\"f_Command\">output-to<\/span>, <span class=\"f_Command\">output-options<\/span> and &lt;comparison&gt; arguments are documented under <a href=\"scripting_reference.html#report_params\" class=\"topiclink\">Common Report Arguments<\/a>.<\/p>\n\r<hr style=\"height:2px; color:#000000; border-width:0; background-color:#000000;\" \/><p class=\"p_Subtitle\"><a id=\"report_params\" class=\"hmanchor\"><\/a><span class=\"f_Subtitle\">Common report arguments<\/span><\/p>\n\r<p class=\"p_Normal\">The report commands (<span class=\"f_Command\">data-report<\/span>, <span class=\"f_Command\">file-report<\/span>, <span class=\"f_Command\">folder-report<\/span>, <span class=\"f_Command\">hex-report<\/span>, <span class=\"f_Command\">media-report<\/span>, <span class=\"f_Command\">picture-report<\/span>, <span class=\"f_Command\">registry-report<\/span>, <span class=\"f_Command\">text-report<\/span> and <span class=\"f_Command\">version-report<\/span>) must include information on where the report should be sent and may include additional information on the output format.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">title<\/span> controls the title that appears at the top of the report.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">output-to<\/span> controls the output target.  It can be <span class=\"f_Command\">printer<\/span>, <span class=\"f_Command\">clipboard<\/span> or a filename.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_Command\">output-options<\/span> is optional and is used differently for each output target.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_Command\">print-color<\/span> or <span class=\"f_Command\">print-mono<\/span> color schemes are available for <span class=\"f_Command\">printer<\/span> output.  By default, <span class=\"f_Command\">print-mono<\/span> is used.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_Command\">print-portrait<\/span> or <span class=\"f_Command\">print-landscape<\/span> orientations are available for <span class=\"f_Command\">printer<\/span> output.  By default, <span class=\"f_Command\">print-portrait<\/span> is used.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_Command\">wrap-none<\/span>, <span class=\"f_Command\">wrap-character<\/span> or <span class=\"f_Command\">wrap-word<\/span> control whether long lines are wrapped.  <span class=\"f_Command\">printer<\/span> output can use all three options.  <span class=\"f_Command\">HTML<\/span> output can use <span class=\"f_Command\">wrap-none<\/span> and <span class=\"f_Command\">wrap-word<\/span>.  By default, <span class=\"f_Command\">wrap-none<\/span> is used.<\/p>\n\r<p class=\"p_SingleSpaced\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_Command\">html-color<\/span>, <span class=\"f_Command\">html-mono<\/span> or <span class=\"f_Command\">html-custom<\/span> are required to output as HTML instead of plain text.  These options are available for <span class=\"f_Command\">clipboard<\/span> and <span class=\"f_Command\">file<\/span> outputs.  <span class=\"f_Command\">html-custom<\/span> requires the filename or URL of an external style sheet.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span>&lt;comparison&gt; can either be a session name or a pair of filenames.  The file report will use the specified comparison instead of the files that have been selected within the script.  When using a saved session, the comparison type must match the report type (e.g. a Table Compare session must use <span class=\"f_Command\">data-report<\/span> or <span class=\"f_Command\">file-report<\/span>).<\/p>\n\r<p class=\"p_Normal\">Examples:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">data-report layout:interleaved output-to:printer &amp;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"> &nbsp; &nbsp;output-options:print-color,print-landscape<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">file-report layout:summary output-to:clipboard &amp;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"> &nbsp; &nbsp;output-options:wrap-word,html-color<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">text-report layout:patch options:patch-unified &amp;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\"> &nbsp; &nbsp;output-to:&quot;<\/span><span class=\"f_CourierFixed\">My Report<\/span><span class=\"f_CourierFixed\">.txt&quot;<\/span><\/p>\n\r"
})
